async function setupCheckbox(docClass, key = docClass) {
  const checkbox = document.querySelector(`.checkbox.${docClass}`);

  checkbox.checked = await getKey(key);
  checkbox.onclick = toggleKey(key);
}

function toggleKey(key) {
  return async (e) => setKey(key, e.target.checked);
}

async function getKey(key) {
  return (await chrome.storage.local.get(key))[key];
}

async function setKey(key, value) {
  await chrome.storage.local.set({ [key]: value });
}

setupCheckbox('enabled');
